// ===================================================
// Fichier aboutdialog.cpp
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#include "aboutdialog.h"
#include "ui_aboutdialog.h"

#include "global.h"

#include <QNetworkInterface>

AboutDialog::AboutDialog(QWidget *parent) :
	QDialog(parent),
	ui(new Ui::AboutDialog)
{
	ui->setupUi(this);
	QString adressesTxt;
	int count = 0;
	foreach (const QHostAddress &address, QNetworkInterface::allAddresses())
	{
		if (address.protocol() == QAbstractSocket::IPv4Protocol && address != QHostAddress(QHostAddress::LocalHost)) {
			count++;
			adressesTxt += address.toString() + "<br>";
		}
	}
	if( count == 1)
		adressesTxt = tr("Adresse IP locale de la machine : <br><br>") + adressesTxt;
	else
		adressesTxt = tr("Adresses IP locales de la machine : <br>") + adressesTxt;
	ui->description->setText( QString("Version 1.%1 compilée le %2<br><br>Site Web : <a href=\"" WEBSITEURL "\">" WEBSITEURL "</a><br><br>%3").arg(VERSION, 2, 10, QLatin1Char('0')).arg(COMPIL_DATETIME).arg(adressesTxt));
	updateGeometry();
}

AboutDialog::~AboutDialog()
{
	delete ui;
}
