// ===================================================
// Fichier connecttodistantstationdialog.h
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#ifndef CONNECTTODISTANTSTATIONDIALOG_H
#define CONNECTTODISTANTSTATIONDIALOG_H

#include <QDialog>
#include <QPointer>
#include "global.h"

namespace Ui {
class ConnectToDistantStationDialog;
}

class ConnectToDistantStationDialog : public QDialog
{
	Q_OBJECT

public:
	explicit ConnectToDistantStationDialog(QWidget *parent = 0);
	~ConnectToDistantStationDialog();

private slots:
	void on_bTest_clicked();
	void on_buttonBox_accepted();
	void on_buttonBox_rejected();

private:
	Ui::ConnectToDistantStationDialog *ui;
	void performTest(bool createStation);
	bool createStation;

	friend class ConnectionDistantStationThread;
};


class ConnectionDistantStationThread : public QThread
{
	Q_OBJECT

public :
	QString message;

protected :
	QPointer< ConnectToDistantStationDialog>_dialog;

protected slots :
	void onEndThread();

public :
	ConnectionDistantStationThread(ConnectToDistantStationDialog *dialog);
	virtual void run();
};


#endif // CONNECTTODISTANTSTATIONDIALOG_H
