// ===================================================
// Fichier downloadfiledialog.h
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#ifndef DOWNLOADFILEDIALOG_H
#define DOWNLOADFILEDIALOG_H

namespace Ui {
class DownloadFileDialog;
}

#include <QDialog>
#include <QThread>

class Station;

class DownloadFileDialog : public QDialog
{
	Q_OBJECT

public:
	explicit DownloadFileDialog(QWidget *parent = 0);
	~DownloadFileDialog();
	void refreshStations();
	void setStationName(const QString &stationName);

public slots:

	void on_cbStationList_activated(const QString &selectedItem);
	void on_bUp_clicked();
	void on_bDisks_clicked();
	void itemClicked(void);
	void doubleClicked(const QModelIndex &);
	void on_bDownload_clicked();
	void on_bClose_clicked();

private slots:
	void on_bHome_clicked();

private:
	void refreshFilesList();
	void initTable();
	Station *getStation();

	Ui::DownloadFileDialog *ui;
	QString selectedStationName;

};

class ExtendedSocket;
class DownloadFilesList : public QThread
{
	Q_OBJECT

protected :
	Ui::DownloadFileDialog *ui;
	QString selectedStation;
	QString messageToDisplay;
	QString newDirToDisplay;
	ExtendedSocket *tempSocket;

protected slots :
	void onEndThread();

public :
	DownloadFilesList();
	void GetFilesList( Ui::DownloadFileDialog *&_ui, Station *_selectedStation);
	void setButtonsStates( bool states);
	virtual void run();
};

class DownloadVolumesList : public DownloadFilesList
{
public :
	DownloadVolumesList();
	void GetVolumesList( Ui::DownloadFileDialog *&_ui, Station *_selectedStation);
	virtual void run();
};

#endif // DOWNLOADFILEDIALOG_H
