// ===================================================
// Fichier main.cpp
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#include "mainwindow.h"
#include <QApplication>
#include <QFontDatabase>
#include <QTranslator>
#include <QSharedMemory>
#include <QMessageBox>
#include <QLibraryInfo>
#include <QDir>
#include <QDesktopServices>

#include <QDebug>
/*
 * Si nécessaire
void customMessageHandler(QtMsgType type, const QMessageLogContext &context, const QString &msg)
{
   Q_UNUSED(context);

   QString dt = QDateTime::currentDateTime().toString("dd/MM/yyyy hh:mm:ss");
   QString txt = QString("[%1] ").arg(dt);

   switch (type)
   {
	  case QtDebugMsg:
		 txt += QString("{Debug} \t\t %1").arg(msg);
		 break;
	  case QtWarningMsg:
		 txt += QString("{Warning} \t %1").arg(msg);
		 break;
	  case QtCriticalMsg:
		 txt += QString("{Critical} \t %1").arg(msg);
		 break;
	  case QtFatalMsg:
		 txt += QString("{Fatal} \t\t %1").arg(msg);
		 abort();
		 break;
   }

   QFile outFile("JOTO_LogFile.log");
   outFile.open(QIODevice::WriteOnly | QIODevice::Append);

   QTextStream textStream(&outFile);
   textStream << txt << endl;
}
*/

int main(int argc, char *argv[])
{
	//qInstallMessageHandler(customMessageHandler);
	QApplication a(argc, argv);

	// test lancement unique
	QSharedMemory sharedMemory;
	sharedMemory.setKey("101010");
	if(sharedMemory.attach())
	{
		QMessageBox::critical(NULL, QObject::tr("JOTO"),QObject::tr("L'application a déjà été lancée."));
		qDebug() << "deja lancé, arret.";
		return 0;
	}
	if (!sharedMemory.create(1)) {
		return 0;
	}

	QFontDatabase fontDatabase;
	fontDatabase.addApplicationFont(":/fonts/LSANS.TTF");
#ifdef Q_OS_WIN
	QApplication::setFont(QFont("Lucida Sans", 9));
#else
	QApplication::setFont(QFont("Lucida Sans", 12));
#endif
	QString locale = QLocale::system().name().section('_', 0, 0);
	qDebug() << "Locale à charger : " << locale;

	QTranslator translator;
	qDebug() << translator.load(":/translations/transfertFile_" + locale);
	translator.load("qt_" + locale,QLibraryInfo::location(QLibraryInfo::TranslationsPath));
	a.installTranslator(&translator);

	QDir dir(QDir::homePath().append("/reception"));
	if( dir.exists() == false)
		dir.mkdir( dir.absolutePath());

	MainWindow w;
	w.show();

	return a.exec();
}
