// ===================================================
// Fichier mainwindow.h
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "global.h"

#include <QMainWindow>
#include <QGraphicsScene>

#include <QTimer>

namespace Ui {
class MainWindow;
}

class Server;
class UDPService;
class QLabel;
class Station;
class QAbstractButton;

//class QGraphicsSceneMouseEvent;

class MainWindow : public QMainWindow
{
	Q_OBJECT

public:
	explicit MainWindow(QWidget *parent = 0);
	~MainWindow();
	void updateMachines();
	void machineClicked(int index, QGraphicsSceneMouseEvent *event);
	void machineHovered(int index);

	int answerButton;

protected :
	void closeEvent(QCloseEvent *);
	void resizeEvent (QResizeEvent * event );
	void dragEnterEvent(QDragEnterEvent *event);
	void dragLeaveEvent(QDragLeaveEvent *event);
	void dropEvent(QDropEvent *event);
	void dragMoveEvent(QDragMoveEvent *event);

signals:
	void refreshScene();
	void continueQuestionSignal(const QString msg);
	void changePortsSignal( int tcpPort, int udpPort);
	void startAutoUpdateSignal(QString label, bool forceUpdate, bool displayResult);

public slots:
	void on_sessionLogout();
	void closeLicenceMessageDialog();
	void gotoLicenseUrl();
	void continueQuestionSlot(const QString msg);
	void changePortsSlot( int tcpPort, int udpPort);
	void startAutoUpdateSlot(QString label, bool forceUpdate, bool displayResult);
	void startAutoUpdateAtStartupSlot() { startAutoUpdateSlot("", false, false); }
	void redrawScenes() { buildScene(); }
	void initNetwork();

private slots:
	void on_actionPresse_papiers_triggered();
	void on_actionReception_triggered();
	void on_actionHistorique_triggered();
	void on_actionReglages_triggered();
	void on_actionOutils_triggered();
	void resetSelection();
	void refreshProgress();
	void on_actionMessages_triggered();
	void on_actionMamachine_triggered();

private:
	QMenu *buildContextMenu();
	void sendClipboard(QAction *action);
	void sendFiles(const QStringList &pathList, int destinationIndex);
	void askForLicenseIfNeeded( Station *station);
	void buildScene();
	void updateToolBar();
	QGraphicsSimpleTextItem *truncateText(double widthMax, QGraphicsScene &scene, QString text);

	Ui::MainWindow *ui;
	QGraphicsScene scene;
	int indexSelection;
	int hoveredMachine;
	bool dragInProgress;
	QMenu *clipboardMenu;
	QTimer *refreshTimer;
	QLabel *progressLabelWidget;
};


class AutoConnectStation : public QThread
{
	Q_OBJECT
private :
	QString stationAddress;

public :
	virtual void run();
	AutoConnectStation(QString stationAddress);
};

class AskLicense : public QThread
{
	Q_OBJECT
private :
	Station *station;

private slots :
	virtual void run();
	void stationDeleted( Station *stationDeleted);
	void abort();

public :
	AskLicense(Station *station);
};


class SendClipboard : public QThread
{
	Q_OBJECT
private :
	Station *station;
	QString clipText;

private slots :
	virtual void run();
	void stationDeleted( Station *stationDeleted);
	void abort();
public :
	SendClipboard(Station *station, QString _clipText);
};

class GetClipboard : public QThread
{
	Q_OBJECT
private :
	Station *station;

private slots :
	virtual void run();
	void stationDeleted( Station *stationDeleted);
	void abort();
public :
	GetClipboard(Station *station);
};



class UpdaterHandler : public QObject
{
	Q_OBJECT

public:
	UpdaterHandler(QObject * parent = 0);
	~UpdaterHandler();

	static bool isRunning;
public slots:
	void updateFileDownloaded();
	void updateUpgradeFileDownloaded();
	void updateUpgradeFileDownloadError(QNetworkReply::NetworkError);
	void progress(qint64, qint64);
	void downloadCanceled();
	void launch( QString label, bool forceAutoUpdate, bool displayResult);

private:
	void startRequest(const QString &urlToDownload);

	QString				   label;
	bool				   forceAutoUpdate;
	bool				   displayResult;
	QNetworkAccessManager  manager;
	QUrl                   url;
	QNetworkRequest        request;
	QNetworkReply          * reply;
	int					   indexFile;
	QMap<QString, QString> attributs;
	int					   lastversion;
	DownloadProgressDialog *downloadProgressDialog;
	QString				   fileInProgress;
	bool				   isAborted;
	QList<QDir>			   dirsCreated;
};


#endif // MAINWINDOW_H
