// ===================================================
// Fichier preferencesdialog.cpp
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#include "preferencesdialog.h"
#include "ui_preferencesdialog.h"

#include "global.h"

#include <QSettings>
#include <QFileDialog>

PreferencesDialog::PreferencesDialog(QWidget *parent) :
	QDialog(parent),
	ui(new Ui::PreferencesDialog)
{
	ui->setupUi(this);
	setFont(QFont(FONTNAMETOUSE));
	prefsDialog = this;

	ui->tab_General->setCurrentIndex(0);
	QSettings qsettings( "AMEA", "JOTO" );

	autoStart = qsettings.value("autoStart", autoStart).toBool();
	ui->cbAutoStart->setChecked( autoStart);

	autoUpdate = qsettings.value("autoUpdate", autoUpdate).toBool();
	ui->cbAutoUpdate->setChecked( autoUpdate);

	PORTNUMBER = qsettings.value("TCPportNumber", PORTNUMBER).toInt();
	ui->lTCPPortNumber->setValidator( new QIntValidator(0, 99999, this) );
	ui->lTCPPortNumber->setText( QString::number(PORTNUMBER));

	BROADCASTPORTNUMBER = qsettings.value("UDPportNumber", BROADCASTPORTNUMBER).toInt();
	ui->lUDPPortNumber->setValidator( new QIntValidator(0, 99999, this) );
	ui->lUDPPortNumber->setText( QString::number(BROADCASTPORTNUMBER));

	autoOpen = qsettings.value("autoOpen", autoOpen).toBool();
	ui->cbAutoOpen->setChecked( autoOpen);

	useSounds = qsettings.value("useSounds", useSounds).toBool();
	//ui->cbUseSounds->setChecked(useSounds);

	toolBarIconsType = qsettings.value("toolBarIconsType", toolBarIconsType).toInt();
	ui->comboBox->setCurrentIndex(toolBarIconsType);

	clickActionType = qsettings.value("clickActionType", clickActionType).toInt();
	ui->comboBoxActionType->setCurrentIndex(clickActionType);

	homeDir = qsettings.value("homeDir", homeDir).toString();
	ui->lStartDir->setText( QDir::toNativeSeparators(homeDir));

	accessType = qsettings.value("accessType", accessType).toInt();
	ui->cbAcces->setCurrentIndex(accessType);
	ui->ldirsList->setEnabled( accessType < 2);

	accessDirList = qsettings.value("accessDirList", accessDirList).toStringList();
	foreach( const QString &item, accessDirList)
		ui->ldirsList->addItem( QDir::toNativeSeparators(item));

	connect( ui->ldirsList, &QListWidget::currentItemChanged, this, &PreferencesDialog::onDirSelected);
	ui->bDelDir->setEnabled(false);
}

PreferencesDialog::~PreferencesDialog()
{
	prefsDialog = NULL;
	delete ui;
}

void PreferencesDialog::updateValues()
{
	ui->lTCPPortNumber->setText( QString::number(PORTNUMBER));
	ui->lUDPPortNumber->setText( QString::number(BROADCASTPORTNUMBER));
}

void PreferencesDialog::on_buttonBox_accepted()
{
	QSettings qsettings( "AMEA", "JOTO" );

	bool ok = false;
	_valueTCP = ui->lTCPPortNumber->text().toInt( &ok);
	if( ok)
		qsettings.setValue( "TCPportNumber", _valueTCP);

	_valueUDP = ui->lUDPPortNumber->text().toInt( &ok);
	if( ok)
		qsettings.setValue( "UDPportNumber", _valueUDP);

	_autoStart = ui->cbAutoStart->isChecked();
	qsettings.setValue( "autoStart", _autoStart);

	_autoOpen = ui->cbAutoOpen->isChecked();
	qsettings.setValue( "autoOpen", _autoOpen);

	_autoUpdate = ui->cbAutoUpdate->isChecked();
	qsettings.setValue( "autoUpdate", _autoUpdate);

	//_useSounds = ui->cbUseSounds->isChecked();
	qsettings.setValue( "useSounds", _useSounds);

	_toolBarIconsType = ui->comboBox->currentIndex();
	qsettings.setValue( "toolBarIconsType", _toolBarIconsType);

	_clickActionType = ui->comboBoxActionType->currentIndex();
	qsettings.setValue( "clickActionType", _clickActionType);

	_homeDir = QDir::fromNativeSeparators( ui->lStartDir->text());
	qsettings.setValue("homeDir", _homeDir);

	_accessType = ui->cbAcces->currentIndex();
	qsettings.setValue( "accessType", _accessType);

	_accessDirList.clear();
	for( int i = 0; i < ui->ldirsList->count(); i++)
		_accessDirList.append( QDir::fromNativeSeparators(ui->ldirsList->item(i)->text()));
	qsettings.setValue( "accessDirList", _accessDirList);

	prefsDialog = NULL;
	done(Accepted);
}

void PreferencesDialog::on_buttonBox_rejected()
{
	prefsDialog = NULL;
	done(Rejected);
}

void PreferencesDialog::on_bAddDir_clicked()
{
	QString dirName = QFileDialog::getExistingDirectory(NULL, tr("Choisissez un dossier :"), "", QFileDialog::ShowDirsOnly);
	if( !dirName.isEmpty()) {
		ui->ldirsList->addItem(QDir::toNativeSeparators(dirName));
	}
}

void PreferencesDialog::on_bDelDir_clicked()
{
	if( ui->ldirsList->currentRow() >= 0)
	{
		ui->ldirsList->model()->removeRow( ui->ldirsList->currentRow());
	}
}

void PreferencesDialog::onDirSelected()
{
	ui->bDelDir->setEnabled( ui->ldirsList->currentRow() >= 0);
}

void PreferencesDialog::on_bChooseStartDir_clicked()
{
	QString dirName = QFileDialog::getExistingDirectory(NULL, tr("Choisissez un dossier d'accueil :"), "", QFileDialog::ShowDirsOnly);
	if( !dirName.isEmpty())
	{
		ui->lStartDir->setText( QDir::toNativeSeparators(dirName));
	}
}

void PreferencesDialog::on_cbAcces_currentIndexChanged(int index)
{
	ui->ldirsList->setEnabled( index < 2);
}
