// ===================================================
// Fichier connecttodistantstationdialog.cpp
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#include "connecttodistantstationdialog.h"
#include "ui_connecttodistantstationdialog.h"

ConnectionDistantStationThread::ConnectionDistantStationThread(ConnectToDistantStationDialog *dialog) : _dialog( dialog)
{
	_dialog->ui->lTestResult->setText( "Test de connexion en cours...");
	_dialog->ui->bTest->setEnabled(false);
	_dialog->ui->buttonBox->button(QDialogButtonBox::Ok)->setEnabled(false);
	connect( this, &ConnectionDistantStationThread::finished, this, &ConnectionDistantStationThread::onEndThread);
	start();
}

void ConnectionDistantStationThread::onEndThread()
{
	if( !_dialog.isNull()) // fenêtre toujours ouverte ?
	{
		_dialog->ui->lTestResult->setText( message);
		_dialog->ui->bTest->setEnabled(true);
		_dialog->ui->buttonBox->button(QDialogButtonBox::Ok)->setEnabled(true);
		if( _dialog->createStation)
			_dialog->done(QDialog::Accepted);
	}
	deleteLater();
}

void ConnectionDistantStationThread::run()
{
	try
	{
		ExtendedSocket socket;
		socket.connectToHost( _dialog->ui->lbStationAddress->text(), PORTNUMBER);
		if( socket.waitForConnectedWithTimer())
		{
			Station::sendInfosTo(socket);
			socket.closeConnection();
			message = tr( "Connexion réussie");
			if( _dialog->createStation)
			{
				QString distantName = socket.peerName();
				QHostAddress distantAddress = socket.peerAddress();
				Station *s = new Station( distantName, distantAddress);
				emit notificationCenter.onStationAdded( s);
			}
		}
		else
			throw( socket.errorString());
	}
	catch( QString msg) {
		message = tr( "Echec : ") + msg;
	}
}


ConnectToDistantStationDialog::ConnectToDistantStationDialog(QWidget *parent) :
	QDialog(parent),
	ui(new Ui::ConnectToDistantStationDialog)
{
	setAttribute(Qt::WA_DeleteOnClose);
	ui->setupUi(this);
	setFont(QFont(FONTNAMETOUSE));
	ui->lbStationAddress->setText("");
	ui->lTestResult->setTextFormat(Qt::RichText);
	ui->lTestResult->setText("");
}

ConnectToDistantStationDialog::~ConnectToDistantStationDialog()
{
	delete ui;
	connectToDistantStation = NULL;
}

void ConnectToDistantStationDialog::performTest(bool _createStation)
{
	createStation = _createStation;
	new ConnectionDistantStationThread(this);
}

void ConnectToDistantStationDialog::on_bTest_clicked()
{
	performTest(false);
}

void ConnectToDistantStationDialog::on_buttonBox_accepted()
{
	performTest( true);
}

void ConnectToDistantStationDialog::on_buttonBox_rejected()
{
	done(Rejected);
}
