// ===================================================
// Fichier customizestationdialog.cpp
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#include "customizestationdialog.h"
#include "ui_customizestationdialog.h"

#include "global.h"

#include <QSettings>
#include <QPushButton>

CustomizeStationDialog::CustomizeStationDialog(QWidget *parent, Station *station) :
	QDialog(parent),
	ui(new Ui::customizeStationDialog),
	_station(station)
{
	ui->setupUi(this);
	setFont(QFont(FONTNAMETOUSE));
	ui->stationName->setText(station->_name);
	ui->usageName->setText(station->getDisplayName());
	connect( ui->usageName, &QLineEdit::textEdited, this, &CustomizeStationDialog::validateUsageName);

	for( int index = 0; index < Station::filesList.length(); index++)
	{
		QListWidgetItem *item = new QListWidgetItem( QIcon( QStringLiteral( FILEPATH) + Station::filesList[ index]), Station::namesList[ index], ui->iconsListWidget);
		item->setData(Qt::UserRole, index);
		item->setSelected(index == station->_iconeIndex);
		ui->iconsListWidget->insertItem(index, item);
	}
	ui->iconsListWidget->setCurrentRow(station->_iconeIndex);
	ui->iconsListWidget->model()->sort(0);
	ui->labelMsg->setVisible(false);
}

CustomizeStationDialog::~CustomizeStationDialog()
{
	delete ui;
}

void CustomizeStationDialog::validateUsageName(QString usageName)
{
	foreach( Station *s, Station::_machines)
		if( s->getDisplayName().compare(usageName, Qt::CaseInsensitive) == 0)
		{
			ui->labelMsg->setText(tr("Ce nom existe déjà sur le réseau."));
			ui->labelMsg->setVisible(true);
			ui->buttonBox->button(QDialogButtonBox::Ok)->setEnabled(false);
			return;
		}
	ui->buttonBox->button(QDialogButtonBox::Ok)->setEnabled(true);
	ui->labelMsg->setVisible(false);
}

void CustomizeStationDialog::on_buttonBox_accepted()
{
	int index = -1;
	if( ui->iconsListWidget->currentItem())
		index = ui->iconsListWidget->currentItem()->data(Qt::UserRole).toInt();
	_station->setUsageNameAndDispath( ui->usageName->text(), index);

	QSettings qsettings( "AMEA", "JOTO" );
	qsettings.setValue( "stationUsageName", ui->usageName->text());
	qsettings.setValue( "iconeIndex", _station->_iconeIndex);

	done(Accepted);
}

void CustomizeStationDialog::on_buttonBox_rejected()
{
	done(Rejected);
}

