// ===================================================
// Fichier getlicensedialog.cpp
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#include "getlicensedialog.h"
#include "ui_getlicensedialog.h"

#include "global.h"
#include "preferencesdialog.h"

#include <QMessageBox>
#include <QDesktopServices>

GetLicenseDialog::GetLicenseDialog(QWidget *parent) :
	QDialog(parent),
	ui(new Ui::GetLicenseDialog)
{
	ui->setupUi(this);
	setFont(QFont(FONTNAMETOUSE));
	ui->lLicenseKey->setText( LicenseManager::getKey());
	ui->lLicenseValue->setText( LicenseManager::getValue());

	connect(ui->lLicenseKey, &QLineEdit::textEdited, this, &GetLicenseDialog::checkLicense);
	connect(ui->lLicenseValue, &QLineEdit::textEdited, this, &GetLicenseDialog::checkLicense);

	getLicenseDialog = this;
	checkLicense();
}

GetLicenseDialog::~GetLicenseDialog()
{
	getLicenseDialog = NULL;
	delete ui;
}

void GetLicenseDialog::on_buttonBox_accepted()
{
	LicenseManager::setKeyAndValue( ui->lLicenseKey->text(), ui->lLicenseValue->text());
	if( prefsDialog)
		prefsDialog->updateValues();

	foreach( Station *s, Station::_machines)
	{
		if( s->_isNotConnected)
			continue;
		try
		{
			ExtendedSocket _socket;
			_socket.connectToHost( s->_address.toString(), PORTNUMBER);
			if( _socket.waitForConnectedWithTimer())
			{
				Station::sendInfosTo(_socket);
				_socket.sendLine( "updatelicense()");
				_socket.sendLine( LicenseManager::getKey());
				_socket.sendLine( LicenseManager::getValue());
				_socket.closeConnection();
			}
			getLicenseDialog = NULL;
			done(Accepted);
		}
		catch(QString msg)
		{
			statutMessages += tr( "Erreur réseau durant le transfert de la licence vers %1 : %2").arg(s->getDisplayName()).arg(msg);
		}
	}

}

void GetLicenseDialog::on_buttonBox_rejected()
{
	getLicenseDialog = NULL;
	done(Rejected);
}

void GetLicenseDialog::checkLicense()
{
	static QString messages[] = {
		tr("La clé saisie est invalide ou non reconnue."),
		tr("Vous avez une licence d'essai (30 jours)."),
		tr("Vous avez une licence valide.")
	};
	int level = LicenseManager::testLicenseLevel( ui->lLicenseKey->text(), ui->lLicenseValue->text());
	ui->lMessage->setText( (ui->lLicenseKey->text().isEmpty() || ui->lLicenseValue->text().isEmpty()) ? "" : messages[level]);
	ui->buttonBox->button( QDialogButtonBox::Ok)->setEnabled( level > 0);
}

void GetLicenseDialog::on_bAcheter_clicked()
{
	if( QDesktopServices::openUrl(QUrl(LICENSEURL)) == false) {
		QMessageBox::critical(NULL, tr("JOTO"),tr("Erreur lors du renvoi sur le site.\n\nVous pouvez y accéder à cette adresse : %1.").arg(LICENSEURL));
	}
}
