// ===================================================
// Fichier global.h
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#ifndef GLOBAL_H
#define GLOBAL_H

#include <QGraphicsPixmapItem>
#include <QPropertyAnimation>

#include "pinet.h"

//#include <QTcpSocket>
#include <QThread>
#include <QDir>
#include <QHostAddress>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QUrl>
#include <QNetworkReply>
#include <QDate>
#include <QElapsedTimer>

// constantes
#define TRANSFERT_BUFF_SIZE (4096 * 16)

#ifdef Q_OS_WIN
#define STATIONOS "pc:"
#define LICENCEFILEPATH "license.key"
#define APPSUFFIX "/"
#define APPSUFFIX2 ""
#else
#define STATIONOS "mac:"
#define LICENCEFILEPATH "../../../license.key"
#define APPSUFFIX "/../../"
#define APPSUFFIX2 "/../../"
#endif

#define FONTNAMETOUSE "Lucida Sans"

#define FILEPATH ":/icones/icones_ordi/"

#define WEBSITEURL "http://joto-transfert.fr/"
#define DOCSURL "http://joto-transfert.fr/docs.html"
#define LICENSEURL "http://joto-transfert.fr/acheter.html"
#define UPDATEURL "http://joto-transfert.fr/versions/"

#define MAXTOKEN 32768
#define TIMEOUT 30000

class MainWindow;
extern MainWindow *mainWindow;

extern int VERSION;
extern const char *COMPIL_DATETIME;
extern int PORTNUMBER, BROADCASTPORTNUMBER;
extern bool autoStart, autoOpen, autoUpdate, useSounds;
extern int toolBarIconsType;
extern int clickActionType;
extern QString homeDir;
extern int accessType;
extern QStringList accessDirList;

// stocke les stations avec lesquelles il y a déjà eu dialogue + le nombre de connexions échouées
extern QMap<QString,int> stationsContactHistory;

class MainWindow;
class Server;
class UDPService;
class PreferencesDialog;
class DownloadFileDialog;
class ConnectToDistantStationDialog;
class GetLicenseDialog;
class LogDialog;
class QMessageBox;

extern Server *tcpService;
extern UDPService *udpService;
extern PreferencesDialog *prefsDialog;
extern DownloadFileDialog *downloadFileDialog;
extern ConnectToDistantStationDialog *connectToDistantStation;
extern GetLicenseDialog *getLicenseDialog;
extern LogDialog *logDialog;
extern QMessageBox *licenceMessageDialog;

extern void CheckStartup( bool startupEnabled);
extern void openReceiveBox();
extern void openApplicationDir();
extern int nbFilesReceived;
extern bool updateChecked;
extern QStringList statutMessages;
extern QString convertFromUFN( QString &fileInUFNNotation);

class Clipboard : public QObject
{
	Q_OBJECT
public :
	Clipboard() {
	}

public slots:
	void setClipboard(const QString &);
};

extern Clipboard clipboardUpdater;

using namespace pt;
class ExtendedSocket : public QObject
{
	Q_OBJECT
private :
	ipstream *_socket;
	QMutex _mutex;
	bool _abortRequested;

public :
	ExtendedSocket();
	ExtendedSocket(ipstream *socket);
	~ExtendedSocket();

	void connectToHost(QString stationAddress, int portNumber);
	void disconnectFromHost();
	void close() { if( _socket) _socket->close(); }
	QString peerName();
	QHostAddress peerAddress();
	QAbstractSocket::SocketState state();
	bool error();
	QString errorString();
	QString readLine() throw(QString);
	QByteArray readBuffer() throw(QString);
	void sendLine(const QString &line) throw(QString);
	void sendBuffer(int size, char *buffer) throw(QString);
	bool waitForConnectedWithTimer(void);
	void closeConnection();
	void abort();
public slots:
	void abortRequested();
};


class TransfertFile;
class TransfertFileBase;

class Station : public QObject
{
	Q_OBJECT
public :

	static QList< Station *>_machines;
	static Station *_localStation;
	static QIcon pcIcon, upIcon, downIcon, targetIcon;
	static QMap<QString, QPixmap *> fileToIcon;
	static QStringList filesList, namesList;
	static QMutex stationMutex;

	QString _name;
	QString _usageName;
	int _iconeIndex;
	QString _stationOS;
	int _stationVersion;
	QHostAddress _address;
	bool _isStationAlive;
	bool _isLocalStation;
	QString _currentDirPath;

	bool _isNotConnected;
	QElapsedTimer _connectionLostTimer;
	QList< TransfertFile *>_receivingTasks;
	QList< TransfertFileBase *>_sendingTasks;

	Station(const QString &name, const QHostAddress &address, bool isLocal = false);
	Station(const QString &name, const QHostAddress &address, QString usageName, int iconeIndex, QString stationOS, int stationVersion);
	void setUsageNameAndDispath(const QString &usageName, int iconeIndex);
	QPixmap *getPixmap();
	QString &getDisplayName();
	void addTransfertTask(const QStringList &filesNames);
	void sendInfosToAllStations();

	static void sendInfosTo(ExtendedSocket &socket);
	static void removeStation(const QString &name);
	static Station *findStation(const QString &name);
	static Station *findStation(const QString &name, const QString &usageName);
	static bool pendingTasks();
	static void stopTasks();
};


extern void sendClipboardToStation(const QString &clipText, Station *station);
extern void getClipboardFromStation( Station *station);

class NotificationCenter : public QObject
{
	Q_OBJECT
public :
	NotificationCenter() {}

signals :
	void onStationAdded( Station *);
	void onStationEdited( Station *);
	void onStationDeleted( Station *);
	void onStationVisibilityChanged( Station *);
	void onApplicationQuit();
};

extern NotificationCenter notificationCenter;


class MovablePixmapItem : public QObject, public QGraphicsPixmapItem
{
	Q_OBJECT
	Q_PROPERTY(QPointF pos READ pos WRITE setPos)
public :
	MovablePixmapItem( const QPixmap &pixmap) : QObject(), QGraphicsPixmapItem( pixmap), _anim( new QPropertyAnimation(this, "pos")) { setScale(1.); }
	~MovablePixmapItem() { delete _anim; }
	void startAnimation(int animationDirection);

private :
	QPropertyAnimation* _anim;
};

class TransfertFileBase
{
public :
	QStringList _filesList;
	long long _totalSize;
	long long _currentSize;
	bool _pauseNeeded;
	bool _pauseAsked;
	volatile bool _exitLoopRequested;

	TransfertFileBase( const QStringList &filesNames, long long fileSize);
	int getPourcent();
	void pause();
	void stop();
};

class TransfertFile : public QThread, public TransfertFileBase
{
	Q_OBJECT
public :
	Station *_station;

	TransfertFile( const QStringList &filesNames, Station *_destStation);
	virtual ~TransfertFile() {}
	bool doSendDir( const QString &root, QDir &file, ExtendedSocket *stream, Station *station);
	bool doSendLink( const QString &root, QDir &file, QString fileTarget, ExtendedSocket *stream, Station *station);
	bool doSendFile( const QString &root, QDir &file, ExtendedSocket *stream, Station *station);
	virtual void run();

protected :
	long long dirSize(const QString &dirName);

public slots:
	void onEndThread();
	void onStationDeletedNotification(Station *station);

private :
	bool _cleanupNeeded;
	volatile bool _exitLoopPerformed;
};



class UserAction
{
public :
	QString _stationName;
	QString _stationDisplayName;
	QStringList _actionParametres;
	QString _libelle;

	UserAction(const QString &stationName, const QString &stationDisplayName, const QStringList &actionParametres)
		: _stationName( stationName), _stationDisplayName( stationDisplayName), _actionParametres( actionParametres)
	{
	}

	virtual ~UserAction() {}
	virtual bool checkActionValidity() = 0;
	virtual void performAction() = 0;
};

class SendFileAction : public UserAction
{
public :
	SendFileAction(const QString &stationName, const QString &stationDisplayName, const QStringList &actionParametres)
		: UserAction( stationName, stationDisplayName, actionParametres)
	{
		if( _actionParametres.size() > 1)
			_libelle = QString("Envoi de %1 fichiers").arg(_actionParametres.count());
		else
			_libelle = QString("Envoi de %1").arg(_actionParametres.first().right(24));
		_libelle = _libelle.append( " vers %1.").arg(_stationDisplayName);
	}
	virtual bool checkActionValidity();
	virtual void performAction();
};

class SendClipboardAction : public UserAction
{
public :
	SendClipboardAction(const QString &stationName, const QString &stationDisplayName, const QStringList &actionParametres)
		: UserAction( stationName, stationDisplayName, actionParametres)
	{
		_libelle = QString("Envoi du presse papier \"%1\"").arg(_actionParametres.first().left(24));
		_libelle = _libelle.append( " vers %1.").arg(_stationDisplayName);
	}
	virtual bool checkActionValidity();
	virtual void performAction();
};


class GetClipboardAction : public UserAction
{
public :
	GetClipboardAction(const QString &stationName, const QString &stationDisplayName, const QStringList &actionParametres)
		: UserAction( stationName, stationDisplayName, actionParametres)
	{
		_libelle = QString("Demande du presse papier de %1.").arg(_stationDisplayName);
	}
	virtual bool checkActionValidity();
	virtual void performAction();
};


class DownloadFilesAction : public UserAction
{
public :
	DownloadFilesAction(const QString &stationName, const QString &stationDisplayName, const QStringList &actionParametres)
		: UserAction( stationName, stationDisplayName, actionParametres)
	{
		if( _actionParametres.size() > 1)
			_libelle = QString("Téléchargement de %1 fichiers").arg(_actionParametres.count());
		else
			_libelle = QString("Téléchargement de %1").arg(_actionParametres.first().right(24));
		_libelle = _libelle.append( " depuis %1.").arg(_stationDisplayName);
	}
	virtual bool checkActionValidity();
	virtual void performAction();
};

extern QList<UserAction *> historique;

class LicenseManager
{
private :
	static QString licenseKey, licenseValue;
	static QDateTime licenseDate;
	static QDateTime firstRunDate;
	static bool isLoaded;
public :
	static QString getKey() { return licenseKey; }
	static QString getValue() { return licenseValue; }
	static QDateTime getDate() { return licenseDate; }
	static void setKeyAndValue(QString _key, QString _value) ;
	static void setFirstRunDate(QDateTime _firstRun) { firstRunDate = _firstRun; }
	static QDateTime getFirstRunDate() { return firstRunDate; }

	static int testLicenseLevel(const QString &key, const QString &value);
	static int getLicenseLevel();
	static bool checkForLicenseLevel(int levelRequested);
};

class DownloadProgressDialog;



#endif // GLOBAL_H
