// ===================================================
// Fichier logdialog.h
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#ifndef LOGDIALOG_H
#define LOGDIALOG_H

#include <QDialog>
#include <QAbstractTableModel>

namespace Ui {
class LogDialog;
}

class TransfertFileBase;

class TasksTableModel : public QAbstractTableModel
{
	Q_OBJECT

public :
	TasksTableModel() { initWithDatas(); }
	void initWithDatas();
	void addTask(TransfertFileBase *task, int direction);
	void removeTask(TransfertFileBase *task);
	void updateTask(TransfertFileBase *task);
	int getData(const QModelIndex &index) const;
	void pauseTask( int rowOfTask);
	void pauseAskedTask(TransfertFileBase *task);
	void stopTask( int rowOfTask);

protected :
	Qt::ItemFlags flags(const QModelIndex &index) const;
	QVariant data(const QModelIndex &index, int role) const;
	QVariant headerData(int /*section*/, Qt::Orientation /*orientation*/, int /*role*/) const { return QVariant(); }
	int rowCount(const QModelIndex &parent) const;
	int columnCount(const QModelIndex &parent) const;
	bool setHeaderData(int, Qt::Orientation, const QVariant &, int) { return false; }

	QList<QPair<TransfertFileBase *, int> > _listTasks;

};

class LogDialog : public QDialog
{
	Q_OBJECT

public:
	explicit LogDialog(QWidget *parent = 0);
	~LogDialog();
	void addMessage(const QString &message);

	virtual void closeEvent(QCloseEvent *e);

	void addTask(TransfertFileBase *task, int direction) { model.addTask( task, direction); }
	void removeTask(TransfertFileBase *task) { model.removeTask( task); }
	void updateTask(TransfertFileBase *task) { model.updateTask( task); }
	void pauseAskedTask(TransfertFileBase *task) { model.pauseAskedTask( task); }

private slots:
	void on_jobsTableView_clicked(const QModelIndex &index);
	void on_bClose_clicked();
	void on_bClear_clicked();

private:
	Ui::LogDialog *ui;
	TasksTableModel model;
	static QPixmap *stop, *pause;
};

#endif // LOGDIALOG_H
