// ===================================================
// Fichier preferencesdialog.h
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#ifndef PREFERENCESDIALOG_H
#define PREFERENCESDIALOG_H

namespace Ui {
class PreferencesDialog;
}

#include <QDialog>

class PreferencesDialog : public QDialog
{
	Q_OBJECT

public:
	explicit PreferencesDialog(QWidget *parent = 0);
	~PreferencesDialog();

	void updateValues();

	void getValues( int &tcpValue, int &udpValue, bool &autoStart, bool &autoOpen, bool &autoUpdate, bool &useSounds, int &toolBarIconsType, int &clickActionType, QString &homeDir, int &accessType, QStringList &accessDirsList)
	{
		tcpValue = _valueTCP;
		udpValue = _valueUDP;
		autoStart = _autoStart;
		autoOpen = _autoOpen;
		autoUpdate = _autoUpdate;
		useSounds = _useSounds;
		toolBarIconsType = _toolBarIconsType;
		clickActionType = _clickActionType;
		homeDir = _homeDir;
		accessType = _accessType;
		accessDirsList = _accessDirList;
	}

private slots:
	void on_buttonBox_accepted();
	void on_buttonBox_rejected();
	void on_bAddDir_clicked();
	void on_bDelDir_clicked();
	void onDirSelected();

	void on_bChooseStartDir_clicked();

	void on_cbAcces_currentIndexChanged(int index);

private:
	Ui::PreferencesDialog *ui;
	int _valueTCP, _valueUDP;
	bool _autoStart, _autoOpen, _autoUpdate;
	bool _useSounds;
	int _toolBarIconsType;
	int _clickActionType;
	QString _homeDir;
	int _accessType;
	QStringList _accessDirList;
};

#endif // PREFERENCESDIALOG_H
