// ===================================================
// Fichier server.h
// Application JOTO
// Copyright (c) AMEA, 2015
// Auteur : AMEA / voir joto-transfert.fr/contact.html
// Diffusé sous license LGPL
// ===================================================

#ifndef SERVER_H
#define SERVER_H

//#include <QTcpServer>
#include "pinet.h"

#include <QUdpSocket>
#include <QTimer>
#include <QThread>

#include <global.h>

using namespace pt;
class ConnectionThread : public QThread
 {
	 Q_OBJECT
 public :
	 ConnectionThread( Server *server, ipstream *socket)
		 : QThread(), _server( server), _connection( NULL),
		   _socket( socket), _station( NULL),
		   _ident(""),
		   _exitLoop(false), _exitPerformed(false), _exceptionToSkip(false)
	 {
		 connect(this, &ConnectionThread::finished, this, &ConnectionThread::onEndThread, Qt::DirectConnection);
		 start();
	 }
	 void run();
	 void stop();

signals:
	void setClipboardInMainThread(QString);

private slots:
	void onEndThread();
	void stationClosedEvent(Station *stationClosed);

 private :
	 Server *_server;
	 ExtendedSocket *_connection;
	 ipstream *_socket;
	 Station *_station;
	 QString _ident;
	 volatile bool _exitLoop;
	 volatile bool _exitPerformed;
	 volatile bool _exceptionToSkip;

	 bool canProcessDir( const QString &dirToRead);
 };

// Server is the the class that implements a simple TCP server.
 class Server : public QThread
 {
	Q_OBJECT
 public:
	Server();
	~Server() {}
	virtual void run() { startServer(); }
	void startServer();
	void restart() { stop(); startServer(); }
	void stop();
	void onConnexionFinished( ConnectionThread *conn);

 protected:
	ipstmserver _server;
	QList<ConnectionThread *>_connections;
	bool _abordRequested;
	//virtual void incomingConnection(qintptr socket);
 };

class Station;

class UDPValidateStation : public QThread
{
	Q_OBJECT
private :
	QString _stationName;
	QString _stationUsageName;
	int _stationIconIndex;
	QString _stationOS;
	int _stationVersion;
	QHostAddress _senderAddress;
	ExtendedSocket *_socket;
	static QList<QHostAddress> _pendingValidations;

private slots :
	void abort();
	virtual void run();
public :
	UDPValidateStation(const QString &_stationName, const QString &_stationUsageName, int _stationIconIndex, QHostAddress _senderAddress, QString _stationOS, int _stationVersion);
};


class UDPService : public QObject
{
	 Q_OBJECT
public:
	 UDPService();
	 void stopService();

private slots:
	 void onTimerUDP();
	 void readPendingDatagrams();
	 void newStationEvent(Station *station);
	 void stationClosedEvent(Station *station);

private:
	 QTimer _timerUDP;
	 QUdpSocket _socketReceiver;
};

class TestStation : public QThread
{
	Q_OBJECT
private :
	Station *_station;
	QTimer _timerTest;
	ExtendedSocket *_socket;
	~TestStation();

private slots :
	void startTest();
	void restartOrStop();
	virtual void run();
	void onStationDeleted(Station *s);
	void abort();
public :
	TestStation(Station *s);
};



#endif // SERVER_H
